#!/bin/bash
echo $0 started at $(date)

. ./common-vars
. ./admin-credentials.rc

PARTICIPANT=${1}

OPENSTACK_USER=hackfest-${PARTICIPANT}
PROJECT=hackfest-${PARTICIPANT}
PASSWORD=hackfest

echo "Creating OpenStack project: $PROJECT"
openstack project create --domain ${ADMIN_DOMAIN} $PROJECT
PROJECT_ID=`openstack project list | grep "${PROJECT} " | awk '{print $2}'`
openstack quota set --cores 64 --ram 131072 --instances 12 $PROJECT_ID &

echo "Creating OpenStack User"
openstack user create --domain ${ADMIN_DOMAIN} --password $PASSWORD $OPENSTACK_USER
openstack role add --user $OPENSTACK_USER --project $PROJECT member &

echo "Creating OpenStack Network RBAC policy access_as_external, for network $NETWORK and project $PROJECT"
openstack network rbac create \
    --target-project $PROJECT \
    --type network \
    --action access_as_external \
    $NETWORK &

echo "Creating OpenStack Network RBAC policy access_as_shared, for network $NETWORK and project $PROJECT"
openstack network rbac create \
    --target-project $PROJECT \
    --type network \
    --action access_as_shared \
    $NETWORK &
wait

echo "Adding security groups"
for i in $(openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID security group list | awk '/default/{ print $2 }'); do
    openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID security group rule create $i --protocol icmp --remote-ip 0.0.0.0/0 &
    openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID security group rule create $i --protocol udp --remote-ip 0.0.0.0/0 &
    openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID security group rule create $i --protocol tcp --remote-ip 0.0.0.0/0 &
done
wait

echo "Creating networks"
NETWORK=management
echo "Creating ${NETWORK} network"
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID network create ${NETWORK} --enable --no-share
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID subnet create ${NETWORK}-subnet --network=${NETWORK} --subnet-range=${MANAGEMENT_SUBNET}.0/24
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID router create ${NETWORK}-router
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID router add subnet ${NETWORK}-router ${NETWORK}-subnet
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID router set --external-gateway osm-ext ${NETWORK}-router

NETWORK=SGi
echo "Creating ${NETWORK} network"
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID network create ${NETWORK} --enable --no-share
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID subnet create ${NETWORK}-subnet --network=${NETWORK} --subnet-range=${SGi_SUBNET}.0/24
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID router create ${NETWORK}-router
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID router add subnet ${NETWORK}-router ${NETWORK}-subnet
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID router set --external-gateway osm-ext ${NETWORK}-router

NETWORK=S1
echo "Creating ${NETWORK} network"
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID network create ${NETWORK} --enable --no-share
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID subnet create ${NETWORK}-subnet --network=${NETWORK} --subnet-range=${S1_SUBNET}.0/24
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID router create ${NETWORK}-router
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID router add subnet ${NETWORK}-router ${NETWORK}-subnet
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID router set --external-gateway osm-ext ${NETWORK}-router

echo "Creating Private network"
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID network create private --enable --no-share
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID subnet create private-subnet --network=private --subnet-range=${PRIVATE_SUBNET}.0/24

echo "Creating ports"
# This port gets created as the admin
IP=`expr ${PARTICIPANT} + 100`
openstack port create --fixed-ip ip-address=${SUBNET}.${IP} --project=${PROJECT} --enable --network osm-ext hackfest-osm-${PARTICIPANT} &
# Create as the project user
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID port create --fixed-ip ip-address=192.168.239.250 --enable --disable-port-security --network private VyOS-private &
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID port create --fixed-ip ip-address=10.0.0.10 --enable --network management OSM-management &
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID port create --fixed-ip ip-address=10.0.0.11 --enable --network management MK8s-management &
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID port create --fixed-ip ip-address=10.0.0.250 --enable --network management VyOS-management &

echo "Creating Keypair"
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID keypair create --public-key ./hackfest_rsa.pub ${KEY_NAME} &
wait

echo "Launching OSM VM"
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID server create --key-name ${KEY_NAME} --flavor ${FLAVOR} --image ubuntu20.04 --nic port-id=hackfest-osm-${PARTICIPANT} --nic port-id=OSM-management --user-data ./osm-cloud-init.yaml osm-${PARTICIPANT}
echo "Launching Microk8s VM"
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID server create --key-name ${KEY_NAME} --flavor ${FLAVOR} --image ubuntu22.04 --nic port-id=MK8s-management microk8s
echo "Launching VyOS Router"
openstack --os-username=$OPENSTACK_USER --os-password=$PASSWORD --os-project-id=$PROJECT_ID server create --flavor m1.small --image vyos-1.1.7 --nic port-id=VyOS-management --nic port-id=VyOS-private --config-drive True --user-data "`pwd`/vyos-userdata.vsh" vyos-pnf-router

echo "Waiting for OSM VM to be ready"

while [ 1 ] ; do
    sleep 5
    ALIVE=$(ssh -T -o ConnectTimeout=1 -o StrictHostKeyChecking=no -i hackfest_rsa ubuntu@${SUBNET}.${IP} 'cloud-init status --wait | tail -1' 2> /dev/null)
    if [ "${ALIVE}" == "status: done" ] ; then break ; fi
done

echo $0 $@ complete at $(date)